
////////////////////////////////////////////////////////////
//	File:		"AnimInstance.h"
//	Author:		[JW] Jason Ware
//	Modified:	[JW] November 20, 2008
//	Purpose:	A class for animating frames for a sprite.
////////////////////////////////////////////////////////////

#ifndef ANIMINSTANCE_H_
#define ANIMINSTANCE_H_

#include "Frame.h"

#include <windows.h>
#include <string>
using namespace std;


class CAnimInstance
{

public:

	/* Public Data Members */

protected:

	/* Protected Data Members */

private:

	/* Private Data Members */
	string							m_szSpriteFile;		// name of the sprite file to animate
	string							m_szCurrentAnim;	// current animation being rendered
	int								m_nCurrentFrame;	// current frame indexed
	float							m_fFrameElapsed;	// amount of time passed in the current frame
	CFrame *						m_pCurrentFrame;	// current frame

	/* Disabled Functions */

public:

	////////////////////////////////////////////////////////////
	//	Function:	Constructor
	//	Modified:	[JW] November 20, 2008
	//	Purpose:	Initializes the object.
	////////////////////////////////////////////////////////////
	CAnimInstance();

	////////////////////////////////////////////////////////////
	//	Function:	Accessors
	//	Modified:	[JW] November 20, 2008
	//	Purpose:	Gets the specified type.
	////////////////////////////////////////////////////////////
	inline string GetSpriteFile(void)				{ return m_szSpriteFile; }
	inline string GetCurrentAnim(void)				{ return m_szCurrentAnim; }
	inline RECT GetCurrentFrameRect(void)			{ return m_pCurrentFrame->GetFrameRect(); }
	inline RECT GetCurrentCollRect(void)			{ return m_pCurrentFrame->GetCollisionRect(); }
	inline int GetCurrentFrameIndex(void)			{ return m_nCurrentFrame; }
	inline float GetFrameElapsed(void)				{ return m_fFrameElapsed; }
	inline CFrame* GetCurrentFrame(void)			{ return m_pCurrentFrame; }

	////////////////////////////////////////////////////////////
	//	Function:	Mutators
	//	Modified:	[JW] November 20, 2008
	//	Purpose:	Sets the specified type.
	////////////////////////////////////////////////////////////
	inline void SetSpriteFile(string szSpriteFile)	{ m_szSpriteFile = szSpriteFile; }

	////////////////////////////////////////////////////////////
	//	Function:	Destructor
	//	Modified:	[JW] November 20, 2008
	//	Purpose:	Deallocates the object.
	////////////////////////////////////////////////////////////
	~CAnimInstance();

	////////////////////////////////////////////////////////////
	//	Function:	Update
	//	Modified:	[JW] November 20, 2008
	//	Purpose:	Updates the frames for a given animation.
	////////////////////////////////////////////////////////////
	void Update(float fElapsedTime);

	////////////////////////////////////////////////////////////
	//	Function:	SetCurrentAnim
	//	Modified:	[JW] November 20, 2008
	//	Purpose:	Changes the current animation to render.
	////////////////////////////////////////////////////////////
	void SetCurrentAnim(string szCurrentAnim);

	////////////////////////////////////////////////////////////
	//	Function:	CalcRect
	//	Modified:	[JW] November 20, 2008
	//	Purpose:	Determines the rect based on player position.
	////////////////////////////////////////////////////////////
	RECT CalcRect(RECT rRect, float fPosX, float fPosY, short sFlip, float fSize = 2.0f);

	////////////////////////////////////////////////////////////
	//	Function:	ResetAnimation
	//	Modified:	[JW] December 2, 2008
	//	Purpose:	Resets the animation to the beginning.
	////////////////////////////////////////////////////////////
	void ResetCurrentAnim(void);

protected:

	/* Protected Functions */

private:

	/* Private Functions */
	////////////////////////////////////////////////////////////
	//	Function:	NextFrame
	//	Modified:	[JW] November 20, 2008
	//	Purpose:	Updates the new frame in the animation.
	////////////////////////////////////////////////////////////
	bool NextFrame();

};

#endif
